// auto_name.js — otomatik isim algılama ve hitap
// Kurulum: index.html'de app.js'ten SONRA ekle:
//   <script src="auto_name.js?v=1"></script>
(function(){
  const chat = document.getElementById('chat');
  if(!chat) return;

  async function apiGetFact(key){
    try{ const r = await fetch('api/memory/get_fact.php?key='+encodeURIComponent(key)); return await r.json(); }
    catch(e){ return {ok:false}; }
  }
  async function apiSetFact(key, value){
    try{ await fetch('api/memory/set_fact.php', { method:'POST', headers:{'Content-Type':'application/json'}, body: JSON.stringify({key, value}) }); }
    catch(e){ /* sessiz geç */ }
  }
  async function apiMe(){
    try{ const r = await fetch('api/auth/me.php'); return await r.json(); }
    catch(e){ return {ok:false}; }
  }

  // 1) Sayfa yüklenince adı biliyorsak nazik bir selam yaz
  (async ()=>{
    const got = await apiGetFact('ad');
    if(got && got.ok && got.value){
      // küçük bir selamlama balonu ekle, mevcut akışı bozma
      const sentinel = document.getElementById('bottom-sentinel') || (function(){ const s=document.createElement('div'); s.id='bottom-sentinel'; chat.appendChild(s); return s; })();
      const item = document.createElement('div'); item.className='msg role-assistant';
      const avatar = document.createElement('div'); avatar.className='avatar'; avatar.textContent='🤖';
      const wrap = document.createElement('div');
      const meta = document.createElement('div'); meta.className='meta'; meta.textContent='VARKAN AI';
      const bubble = document.createElement('div'); bubble.className='bubble'; bubble.textContent = `Merhaba ${got.value} 👋 Bugün ne yapıyoruz?`;
      wrap.appendChild(meta); wrap.appendChild(bubble); item.appendChild(avatar); item.appendChild(wrap);
      chat.insertBefore(item, sentinel);
      setTimeout(()=>{ sentinel.scrollIntoView({block:'end'}); }, 50);
    }else{
      // isim yoksa, giriş yapmış kullanıcı adını ilk fırsatta isim olarak kaydet
      const me = await apiMe();
      if(me && me.ok && me.user && me.user.username){
        const existing = await apiGetFact('ad');
        if(!(existing && existing.ok)){ await apiSetFact('ad', me.user.username); }
      }
    }
  })();

  // 2) Kullanıcı mesajlarından isim çıkarımı
  const namePatternList = [
    /\bbenim\s+ad[ıi]m\s+([A-ZÇĞİÖŞÜ][a-zçğıöşü]+(?:\s+[A-ZÇĞİÖŞÜ][a-zçğıöşü]+)?)\b/u,
    /\bad[ıi]m\s+([A-ZÇĞİÖŞÜ][a-zçğıöşü]+(?:\s+[A-ZÇĞİÖŞÜ][a-zçğıöşü]+)?)\b/u,
    /\bismim\s+([A-ZÇĞİÖŞÜ][a-zçğıöşü]+(?:\s+[A-ZÇĞİÖŞÜ][a-zçğıöşü]+)?)\b/u,
    /\bbana\s+([A-ZÇĞİÖŞÜ][a-zçğıöşü]+)\s+de\b/u,
  ];

  function extractName(text){
    if(!text) return null;
    // İlk harfi büyük olan isimleri hedefliyoruz; aşırı genel kalıbı (sadece "ben Ali") bilerek kullanmıyoruz.
    for(const rx of namePatternList){
      const m = text.match(rx);
      if(m && m[1]){
        const name = m[1].trim();
        if(name.length>=2 && name.length<=40) return name;
      }
    }
    return null;
  }

  // Son eklenen user balonlarını dinle ve isim algılarsan kaydet
  const obs = new MutationObserver(async (mutations)=>{
    for(const mu of mutations){
      for(const node of mu.addedNodes){
        if(!(node instanceof HTMLElement)) continue;
        if(node.classList.contains('msg') && node.classList.contains('role-user')){
          const bubble = node.querySelector('.bubble');
          const text = bubble ? bubble.textContent || '' : '';
          const name = extractName(text);
          if(name){
            // mevcut adla aynıysa tekrar kaydetme
            const got = await apiGetFact('ad');
            if(!got || !got.ok || (got.value && got.value.toLowerCase() !== name.toLowerCase())){
              await apiSetFact('ad', name);
              // küçük bir teyit mesajı bırak (akışı bozmadan)
              const sentinel = document.getElementById('bottom-sentinel') || (function(){ const s=document.createElement('div'); s.id='bottom-sentinel'; chat.appendChild(s); return s; })();
              const item = document.createElement('div'); item.className='msg role-assistant';
              const avatar = document.createElement('div'); avatar.className='avatar'; avatar.textContent='🤖';
              const wrap = document.createElement('div');
              const meta = document.createElement('div'); meta.className='meta'; meta.textContent='VARKAN AI';
              const bubble2 = document.createElement('div'); bubble2.className='bubble'; bubble2.textContent = `Not ettim ${name} 👍 Bundan sonra sana adınla hitap edeceğim.`;
              wrap.appendChild(meta); wrap.appendChild(bubble2); item.appendChild(avatar); item.appendChild(wrap);
              chat.insertBefore(item, sentinel);
              setTimeout(()=>{ sentinel.scrollIntoView({block:'end'}); }, 30);
            }
          }
        }
      }
    }
  });
  obs.observe(chat, { childList:true });

})();